/*
 * Copyright (c) 2004, 2005 Voltaire, Inc. All rights reserved.
 * Copyright (c) 2002-2005 Mellanox Technologies LTD. All rights reserved.
 * Copyright (c) 1996-2003 Intel Corporation. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: osm_mcmember.h 1743 2005-02-06 09:38:35Z shaharf $
 */


/*
 * Abstract:
 * 	Declaration of osm_mcmember_t.
 *	This object represents an IBA mcmember.
 *	This object is part of the OpenSM family of objects.
 *
 * Environment:
 * 	Linux User Mode
 *
 * $Revision: 1.4 $
 */

#ifndef _OSM_MCMEMBER_H_
#define _OSM_MCMEMBER_H_

#include <complib/cl_qmap.h>
#include <complib/cl_qlist.h>
#include <iba/ib_types.h>
#include <opensm/osm_base.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else /* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif /* __cplusplus */

BEGIN_C_DECLS

/****h* OpenSM/MCMember
* NAME
*	MCMember
*
* DESCRIPTION
*	The MCMember object encapsulates the information needed by the
*	OpenSM to manage mcmembers.  The OpenSM allocates one MCMember object
*	per mcmember in the IBA subnet.
*
*	The MCMember object is not thread safe, thus callers must provide
*	serialization.
*
*	This object should be treated as opaque and should be
*	manipulated only through the provided functions.
*
* AUTHOR
*	Ranjit Pandit, Intel
*
*********/
/****s* OpenSM: MCMember/osm_mcmember_t
* NAME
*	osm_mcmember_t
*
* DESCRIPTION
*	MCMember structure.
*
*	This object should be treated as opaque and should
*	be manipulated only through the provided functions.
*
* SYNOPSIS
*/
typedef struct _osm_mcmember
{
	cl_map_item_t				map_item;
	ib_member_rec_t				mcmember_rec;
	cl_qlist_t					mcmember_port_list;

} osm_mcmember_t;

/*
* FIELDS
*	map_item
*		Linkage structure for cl_qmap.  MUST BE FIRST MEMBER!
*
*	mcmember_rec
*		The IBA defined MCMemberRecord data for this mcmember.
*
*	member_port_list
*		List of Port specific information for each port that in
*		member of a MultiCast Group.
*
* SEE ALSO
*	MCMember object
*********/

/****s* OpenSM: MCMember/osm_mcmember_t
* NAME
*   osm_mcmember_t
*
* DESCRIPTION
*   MCMember structure.
*
*   This object should be treated as opaque and should
*   be manipulated only through the provided functions.
*
* SYNOPSIS
*/
typedef struct _osm_mcmember_port
{
    cl_list_item_t         list_item;
	ib_gid_t				port_gid;
	uint8_t					scope_state;

} osm_mcmember_port_t;

/*
* FIELDS
*	list_item
*		DESCRIPTION???
*
*	port_gid
*		DESCRIPTION???
*
*	scope_state
*		description???
*
* SEE ALSO
*	MCMember object
*********/

END_C_DECLS

#endif	/* _OSM_MCMEMBER_H_ */
